﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Mvc;

namespace CoderBlog.JSValues
{
    public class JavaScriptBuilder
    {
        private const string Type = "application/javascript";

        private readonly TagBuilder scriptTag = new TagBuilder("script");

        private readonly StringBuilder content = new StringBuilder();

        private bool hasNewLine = false;

        public bool TagHasType { get; set; }

        /// <summary>
        /// Call this from HTML helper to render the javascript object
        /// </summary>
        /// <returns></returns>
        public string Render()
        {
            scriptTag.InnerHtml = RenderContent();
            return scriptTag.ToString(TagRenderMode.Normal);
        }

        public string RenderContent()
        {
            return content.ToString();
        }

        public string RenderStatement()
        {
            if (TagHasType)
            {
                scriptTag.MergeAttribute("type", Type);
            }

            scriptTag.InnerHtml = string.Empty;

            return scriptTag.ToString(TagRenderMode.Normal);
        }

        public void AddAttributesToStatement(string key, string value)
        {
            scriptTag.MergeAttribute(key, value);
        }
        /// <summary>
        /// call this method to add the serialized object 
        /// </summary>
        /// <param name="statement"></param>
        public void AddStatement(string statement)
        {
            if (!hasNewLine)
            {
                content.AppendLine();
                hasNewLine = true;
            }

            content.AppendLine(statement);
        }
    }
}
