﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CoderBlog.JSValues;

namespace CoderBlog.Web
{
    public static class HTMLHelper
    {
        public static MvcHtmlString RenderJsValues(this HtmlHelper html)
        {
            var options = JavaScriptHelpers.CreateValuesFrom(html.ViewContext.HttpContext);

            var configBuilder = new JavaScriptBuilder();
            configBuilder.AddStatement(JavaScriptHelpers.SerializeAsVariable(options, "page"));

            return new MvcHtmlString(configBuilder.Render());
        }
    }
}