﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace CoderBlog.JSValues
{
    public static class JavaScriptHelpers
    {
        public static string SerializeAsVariable<T>(T obj, string varName)
        {
            var json = JsonConvert.SerializeObject(obj);
            return string.Format("var {0} = {1};", varName, json);
        }

        public static string MethodCall(string methodName, params object[] arguments)
        {
            var argsBuilder = new StringBuilder();
            if (arguments != null)
            {
                for (var i = 0; i < arguments.Length; i++)
                {
                    var serialized = JsonConvert.SerializeObject(arguments[i]);

                    var format = i < arguments.Length - 1 ? "{0}, " : "{0}";

                    argsBuilder.AppendFormat(format, serialized);
                }
            }

            return string.Format("{0}({1});", methodName, argsBuilder.ToString());
        }

        public static JsonValues CreateValuesFrom(System.Web.HttpContextBase httpContext)
        {
            var options = new JsonValues
            {
                PageValues = JSValues.GetPageValues(httpContext)
            };

            return options;
        }
    }



    public class JsonValues
    {
        [JsonProperty(PropertyName = "pageValues")]
        public Dictionary<string, object> PageValues { get; set; }
    }
}
